unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, TeEngine, TeeFunci, Series, ExtCtrls, TeeProcs, ArrowCha,
  BubbleCh, GanttCh, Chart, CheckLst;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Chart1: TChart;
    CBoxSeriesType: TComboBox;
    ButtonAddSeries: TButton;
    CheckListBoxSeries: TCheckListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure ButtonAddSeriesClick(Sender: TObject);
    procedure CheckListBoxSeriesClickCheck(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ------------------------------------------------------------------------
//     CHART
// ------------------------------------------------------------------------

//  AddNewSeries   RqChart  
// ,   RqSeriesType,
//     :
// 0 - TLineSeries
// 1 - TBarSeries
// 2 - THorizBarSeries
// 3 - TAreaSeries
// 4 - TPointSeries
// 5 - TPieSeries
// 6 - TArrowSeries
// 7 - TBubbleSeries
// 8 - TGanttSeries
//  RqCheckListBoxSeries   
//   ,     
//     nil.
procedure AddNewSeries (RqChart : TChart;
                        RqSeriesType : integer;
                        RqCheckListBoxSeries : TCheckListBox);
var WSeries : TChartSeries;  //     
    Ind     : integer;       //  
    WStr    : string;        //  
begin
  WSeries := nil;
  try
    case RqSeriesType of
    0 : // TLineSeries
        begin
          WSeries := TLineSeries.Create(RqChart);
         (WSeries as TLineSeries).Title := 'TLineSeries';
         (WSeries as TLineSeries).Tag := 100;
         //Chart1.SeriesList.Series[Ind].Name
        end;
    1 : // TBarSeries
        begin
          WSeries := TBarSeries.Create(RqChart);
          (WSeries as TBarSeries).Title := 'TBarSeries';
          (WSeries as TBarSeries).Tag := 101;
        end;
    2 : // THorizBarSeries
        begin
          WSeries := THorizBarSeries.Create(RqChart);
          (WSeries as THorizBarSeries).Title := 'THorizBarSeries';
          (WSeries as THorizBarSeries).Tag := 102;
        end;
    3 : // TAreaSeries
        begin
          WSeries := TAreaSeries.Create(RqChart);
          (WSeries as TAreaSeries).Title := 'TAreaSeries';
          (WSeries as TAreaSeries).Tag := 103;
        end;
    4 : // TPointSeries
        begin
          WSeries := TPointSeries.Create(RqChart);
          (WSeries as TPointSeries).Title := 'TPointSeries';
          (WSeries as TPointSeries).Tag := 104;
        end;
    5 : // TPieSeries
        begin
          WSeries := TPieSeries.Create(RqChart);
          (WSeries as TPieSeries).Title := 'TPieSeries';
          (WSeries as TPieSeries).Tag := 105;
        end;
    6 : // TArrowSeries
        begin
          WSeries := TArrowSeries.Create(RqChart);
          (WSeries as TArrowSeries).Title := 'TArrowSeries';
          (WSeries as TArrowSeries).Tag := 106;
        end;
    7 : // TBubbleSeries
        begin
          WSeries := TBubbleSeries.Create(RqChart);
          (WSeries as TBubbleSeries).Title := 'TBubbleSeries';
          (WSeries as TBubbleSeries).Tag := 107;
        end;
    8 : // TGanttSeries
        begin
          WSeries := TGanttSeries.Create(RqChart);
          (WSeries as TGanttSeries).Title := 'TGanttSeries';
          (WSeries as TGanttSeries).Tag := 108;
        end;
    end; // of case
  except
    WSeries := nil;
    ShowMessage ('   ');
  end;
  if WSeries <> nil
  then begin
     //   Chart  
     RqChart.AddSeries(WSeries);
     //   
     for Ind:=0 to RqChart.SeriesList.Count -1
     do begin
       if Ind = RqChart.SeriesList.Count -1
       then RqChart.SeriesList.Series[Ind].Active := True
       else RqChart.SeriesList.Series[Ind].Active := False;
     end;
     //   
     if RqCheckListBoxSeries <> nil
     then begin
        RqCheckListBoxSeries.Items.Clear;
        for Ind:=0 to RqChart.SeriesList.Count -1
        do begin
           if RqCheckListBoxSeries <> nil
           then begin
             //      
             WStr := RqChart.SeriesList.Series[Ind].Title
                  + ' - ' + IntToStr(Ind);
             RqCheckListBoxSeries.Items.Add(WStr);
           end;
           //      
           if Ind = RqChart.SeriesList.Count -1
           then begin
              RqCheckListBoxSeries.Checked[Ind] := True;
              RqCheckListBoxSeries.ItemIndex := Ind;
           end else RqCheckListBoxSeries.Checked[Ind] := False;
        end;
     end;
  end;
end; // of procedure AddNewSeries

// ------------------------------------------------------------------------
//        TLineSeries
procedure TestLineSeries (RqChart : TChart; RqSeriesInd, NumPoint : integer);
var   Ind, Rnd : integer;  //   
      WX       : double;   //  
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TLineSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TLineSeries)
         do begin
            if Count <> NumPoint
            //      NumPoint
            then begin
               //    
               Clear;
               //    X,Y
               for Ind:= 1 to NumPoint do AddXY(Ind, 0);
            end
            else begin
               Rnd := Random (3);
               for Ind := 0 to Count -1 do
               begin
                  //     Y
                  WX := XValue[Ind];
                  case Rnd of
                     0 : YValue[Ind] := NumPoint * Sin(WX * 2* Pi /NumPoint);
                     1 : YValue[Ind] := (WX * WX) / NumPoint;
                     2 : YValue[Ind] := NumPoint - Random (NumPoint div 2);
                 end;
               end;
            end;
         end; // of with
     end else ShowMessage ('     TLineSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestLineSeries

// ------------------------------------------------------------------------
//        TBarSeries
procedure TestBarSeries (RqChart : TChart; RqSeriesInd, MaxTest : integer);
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TBarSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TBarSeries)
         do begin
              //    
              Clear ;
              //  
              AddBar(Random(MaxTest), '',    clRed);
              AddBar(Random(MaxTest), '',     clBlue);
              AddBar(Random(MaxTest), '', clGreen);
              AddBar(Random(MaxTest), '',   clWhite);
              AddBar(Random(MaxTest), '',    clLime);
         end;
     end else ShowMessage ('     TBarSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestBarSeries


// ------------------------------------------------------------------------
//        THorizBarSeries
procedure TestHorizBarSeries (RqChart : TChart; RqSeriesInd, MaxTest : integer);
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is THorizBarSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as THorizBarSeries)
         do begin
              //    
              Clear ;
              //  
              AddBar(Random(MaxTest), '',    clRed);
              AddBar(Random(MaxTest), '',     clBlue);
              AddBar(Random(MaxTest), '', clGreen);
              AddBar(Random(MaxTest), '',   clWhite);
              AddBar(Random(MaxTest), '',    clLime);
         end;
     end else ShowMessage ('     THorizBarSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestHorizBarSeries

// ------------------------------------------------------------------------
//        TAreaSeries
procedure TestAreaSeries (RqChart : TChart; RqSeriesInd, NumPoint : integer);
var   Ind, Rnd : integer;  //   
      WX       : double;   //  
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TAreaSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TAreaSeries)
         do begin
            if Count <> NumPoint
            //      NumPoint
            then begin
               //    
               Clear;
               //    X,Y
               for Ind:= 1 to NumPoint do AddXY(Ind, 0);
            end
            else begin
               Rnd := Random (3);
               for Ind := 0 to Count -1 do
               begin
                  //     Y
                  WX := XValue[Ind];
                  case Rnd of
                     0 : YValue[Ind] := NumPoint * Sin(WX * 2* Pi /NumPoint);
                     1 : YValue[Ind] := (WX * WX) / NumPoint;
                     2 : YValue[Ind] := NumPoint - Random (NumPoint div 2);
                 end;
               end;
            end;
         end; // of with
     end else ShowMessage ('     TAreaSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestAreaSeries

// ------------------------------------------------------------------------
//        TPointSeries
procedure TestPointSeries (RqChart : TChart; RqSeriesInd, NumPoint : integer);
var   Ind, Rnd : integer;  //   
      WX       : double;   //  
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TPointSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TPointSeries)
         do begin
            if Count <> NumPoint
            //      NumPoint
            then begin
               //    
               Clear;
               //    X,Y
               for Ind:= 1 to NumPoint do AddXY(Ind, Ind);
            end
            else begin
               Rnd := Random (3);
               for Ind := 0 to Count -1 do
               begin
                  //     Y
                  WX := XValue[Ind];
                  //    
                  ValueColor[Ind] := RGB(Random(255), Random(255),Random(255));
                  case Rnd of
                     0 : YValue[Ind] := NumPoint * Sin(WX * 2* Pi /NumPoint);
                     1 : YValue[Ind] := (WX * WX) / NumPoint;
                     2 : YValue[Ind] := NumPoint - Random (NumPoint div 2);
                 end;
               end;
            end;
         end; // of with
     end else ShowMessage ('     TPointSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestPointSeries


// ------------------------------------------------------------------------
//        TPieSeries
procedure TestPieSeries (RqChart : TChart; RqSeriesInd, MaxTest : integer);
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TPieSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TPieSeries)
         do begin
              //    
              Clear ;
              //  
              AddPie(Random(MaxTest), '',    clRed);
              AddPie(Random(MaxTest), '',     clBlue);
              AddPie(Random(MaxTest), '', clGreen);
              AddPie(Random(MaxTest), '',   clWhite);
              AddPie(Random(MaxTest), '',    clLime);
         end;
     end else ShowMessage ('     TPieSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestPieSeries

// ------------------------------------------------------------------------
//        TArrowSeries
procedure TestArrowSeries (RqChart : TChart; RqSeriesInd, NumPoint : integer);
var   Ind : integer;  //   
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TArrowSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TArrowSeries)
         do begin
            //    
            StartXValues.DateTime:=False;
	          EndXValues.DateTime:=False;
            //    
            Clear;
            //    
            for Ind:= 0 to NumPoint do
            begin
              //    
              AddArrow(Ind,
                       Ind,
                       Ind + Random(Ind),
                       Ind + Random(Ind) * Cos(Ind * 2 * Pi / NumPoint)
                       );
              //    
              ValueColor[Ind] := RGB(Random(255), Random(255),Random(255));
              // StartXValues
              // EndXValues
            end;
         end; // of with
     end else ShowMessage ('     TArrowSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestArrowSeries

// ------------------------------------------------------------------------
//        TBubbleSeries
procedure TestBubbleSeries (RqChart : TChart; RqSeriesInd, NumPoint : integer);
var   Ind : integer;  //   
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TBubbleSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TBubbleSeries)
         do begin
            //    
            Clear;
            //   
            for Ind:= 0 to NumPoint do
            begin
              //    
              AddBubble(Ind,                                       // X
                        NumPoint * cos(Ind * 2 * Pi / NumPoint),   // Y
                        1 + Random(3)                              // Radius
                        );
              //    
              ValueColor[Ind] := RGB(Random(255), Random(255),Random(255));
            end;
         end; // of with
     end else ShowMessage ('     TBubbleSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestBubbleSeries

// ------------------------------------------------------------------------
//        TGanttSeries
// GanttSeries -  ()  -   
//    ;
procedure TestGanttSeries (RqChart : TChart; RqSeriesInd : integer);
type WorkRec = record
  WMame  : string;     //  
  WYear  : integer;    //  
  WMonth : byte;       //  
  WDay   : byte;       //  
end;
const ArrWork : array [1..8] of WorkRec =
((WMame : ' ';        WYear : 2010; WMonth : 1; WDay : 1),
 (WMame : '  ';      WYear : 2010; WMonth : 1; WDay : 10),
 (WMame : '  ';   WYear : 2010; WMonth : 1; WDay : 20),
 (WMame : '. , ';     WYear : 2010; WMonth : 2; WDay : 10),
 (WMame : ' ';            WYear : 2010; WMonth : 5; WDay : 25),
 (WMame : ' ';        WYear : 2010; WMonth : 7; WDay : 10),
 (WMame : ' ';     WYear : 2010; WMonth : 7; WDay : 20),
 (WMame : ' ';             WYear : 2010; WMonth : 7; WDay : 30)
);
var WGannt, NGannt : Longint;
    Ind : integer;
    WMame : string;
    WYear  : integer;
    WMonth : byte;
    WDay   : byte;
begin
 if RqChart.SeriesCount > 0
 then begin
   if (RqSeriesInd >=0) and (RqSeriesInd < RqChart.SeriesCount)
   then begin
     if RqChart.Series[RqSeriesInd] is TGanttSeries
     then begin
         with (RqChart.Series[RqSeriesInd] as TGanttSeries)
         do begin
              //   
              Stairs := False;
              //    
              ShowInLegend := False;
              //    
              Clear;
              //    
              Ind := Low(ArrWork);
              WMame  := ArrWork[Ind].WMame;
              WYear  := ArrWork[Ind].WYear;
              WMonth := ArrWork[Ind].WMonth;
              WDay   := ArrWork[Ind].WDay;
              WGannt := AddGantt( EncodeDate(WYear - 1 , 12, 20 ),
                                  EncodeDate(WYear, WMonth, WDay),
                                  Ind,
                                  WMame);
              //    
              for Ind := Low(ArrWork) + 1 to High(ArrWork)
              do begin
                 //    
                 NGannt := AddGantt( EncodeDate(WYear, WMonth, WDay ),
                                     EncodeDate (ArrWork[Ind].WYear,
                                                 ArrWork[Ind].WMonth,
                                                 ArrWork[Ind].WDay),
                                     Ind,
                                     ArrWork[Ind].WMame);
                 //     
                 NextTask [WGannt]:= NGannt;
                 WGannt := NGannt;
                 //       
                 WMame  := ArrWork[Ind].WMame;
                 WYear  := ArrWork[Ind].WYear;
                 WMonth := ArrWork[Ind].WMonth;
                 WDay   := ArrWork[Ind].WDay;

              end;
         end;
     end else ShowMessage ('     TPieSeries');
   end else ShowMessage ('      CHART');
 end else ShowMessage ('CHART     ');
end; // of procedure TestGanttSeries

// ------------------------------------------------------------------------
//   
// ------------------------------------------------------------------------
//      
procedure TForm1.ButtonAddSeriesClick(Sender: TObject);
begin
  AddNewSeries (Chart1, CBoxSeriesType.ItemIndex, CheckListBoxSeries);
end;

//    
procedure TForm1.Button1Click(Sender: TObject);
const Test = 60;
var   Ind : integer;
      Rnd : integer;
begin
   Rnd := Test - Random(Test div 2);
   Ind := CheckListBoxSeries.ItemIndex;
   if (Ind >= 0) and (Ind < Chart1.SeriesCount)
   then begin
     case Chart1.Series[Ind].Tag of
     100 : TestLineSeries (Chart1, Ind, Test);
     101 : TestBarSeries  (Chart1, Ind, Rnd);
     102 : TestHorizBarSeries (Chart1, Ind, Rnd);
     103 : TestAreaSeries (Chart1, Ind, Test);
     104 : TestPointSeries (Chart1, Ind, Test);
     105 : TestPieSeries  (Chart1, Ind, Rnd);
     106 : TestArrowSeries (Chart1, Ind, 20);
     107 : TestBubbleSeries (Chart1, Ind, Test);
     108 : TestGanttSeries (Chart1, Ind);
     end; // of case
   end;
end;

//  /   
procedure TForm1.CheckListBoxSeriesClickCheck(Sender: TObject);
var Ind : integer;
begin
  for Ind := 0 to CheckListBoxSeries.Count -1
  do begin
     if (Ind >= 0) and (Ind < Chart1.SeriesCount)
     then begin
         if CheckListBoxSeries.Checked[Ind]
         then Chart1.Series[Ind].Active := True
         else Chart1.Series[Ind].Active := False;
     end;
  end;
end;

end.
